/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.memorysettings.MemorysettingsMod;

public class CommonConfiguration {
    public int minimumClient = 2500;
    public int minimumServer = 2500;
    public int maximumClient = 8500;
    public int maximumServer = 8500;
    public boolean disableWarnings = false;
    public String helpfullinkmessage = "See <a href='https://minecrafthelp.co.uk/how-to-add-more-ram-to-minecraft/'>https://minecrafthelp.co.uk/how-to-add-more-ram-to-minecraft/</a> on how to change your memory settings.";

    protected CommonConfiguration() {
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Set the clients minimum memory warning threshold in MB. Choose the lowest value possible which keeps the pack playable. default:2500, min 2500, max 25000");
        entry.addProperty("minimumClient", (Number)this.minimumClient);
        root.add("minimumClient", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Set the clients maximum memory warning threshold in MB. Choose a generous maximum with some additional over the required, e.g.recommended memory for the pack is 6000mb then set this to ~8000mb");
        entry2.addProperty("maximumClient", (Number)this.maximumClient);
        root.add("maximumClient", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Set the servers minimum memory warning threshold in MB. Choose the lowest value possible which keeps the pack playable. default:2500, min 2500, max 25000");
        entry3.addProperty("minimumServer", (Number)this.minimumServer);
        root.add("minimumServer", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Set the servers maximum memory warning threshold in MB. Choose a generous maximum with some additional over the required, e.g.recommended is 6000mb then set this to ~8000mb");
        entry4.addProperty("maximumServer", (Number)this.maximumServer);
        root.add("maximumServer", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Disable the memory warnings, default: false");
        entry5.addProperty("disableWarnings", Boolean.valueOf(this.disableWarnings));
        root.add("disableWarnings", (JsonElement)entry5);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "Set the help message for changing ram allocation, you can use html here e.g. for setting a link to a wiki page");
        entry6.addProperty("helpfullinkmessage", this.helpfullinkmessage);
        root.add("helpfullinkmessage", (JsonElement)entry6);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            MemorysettingsMod.LOGGER.error("Config file was empty!");
            return;
        }
        try {
            this.minimumClient = data.get("minimumClient").getAsJsonObject().get("minimumClient").getAsInt();
            this.maximumClient = data.get("maximumClient").getAsJsonObject().get("maximumClient").getAsInt();
            this.minimumServer = data.get("minimumServer").getAsJsonObject().get("minimumServer").getAsInt();
            this.maximumServer = data.get("maximumServer").getAsJsonObject().get("maximumServer").getAsInt();
            this.disableWarnings = data.get("disableWarnings").getAsJsonObject().get("disableWarnings").getAsBoolean();
            this.helpfullinkmessage = data.get("helpfullinkmessage").getAsJsonObject().get("helpfullinkmessage").getAsString();
        }
        catch (Exception e) {
            MemorysettingsMod.LOGGER.error("Could not parse config file", (Throwable)e);
        }
    }
}

